﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using Telerik.Web.UI;
using System.Collections;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class ReportPatientTreatmentChanges : System.Web.UI.Page
{

    #region Variable Declarations

    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser;
    string _reportName = "PatientTreatmentChangesReport";

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            //Panel5.Visible = true;
            if (!IsPostBack)
            {
                SetDropDownListLevel();
                EnableDropDownListsVisnAndStation(false, false);

                System.Data.DataTable dataTable = SqlProvider.ExecuteSPDataTable(
                           "RegistryConnectionString", "TBI.usp_GetIOCInstrumentTypes",
                           new object[] { });

                if (dataTable != null)
                {
                    ddlSurveyTypes.DataSource = dataTable;
                    ddlSurveyTypes.DataBind();
                }
                if (ddlSurveyTypes.Items.Count > 0)
                {
                    foreach (ListItem item in ddlSurveyTypes.Items)
                    {
                        item.Selected = true;
                    }
                }

                DateFrom.Date.Text = "1/1/2012";
                DateTo.Date.Text = DateTime.Now.ToString("MM/dd/yyyy");
                //lblReportTitle.Visible = false;
            }
            EnableButtonRunReport();
            DisableReportViewer();
        }
        else
        {
            //Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    private void PopulateRdgrdPatTreatment(DateTime? startDate, DateTime? endDate, string surveytypeid, string facilityid, string notetype, string scoretype)
    {

        System.Data.DataTable dataTableGrid = SqlProvider.ExecuteSPDataTable(
                   "RegistryConnectionString", "[TBI].[GetAllPatientOutcomeChangesReport]",
                   new object[] { startDate, endDate, surveytypeid, facilityid, notetype, scoretype });

        if (dataTableGrid != null)
        {
            rdgrdPatTreatment.DataSource = dataTableGrid;
            rdgrdPatTreatment.DataBind();
        }
    }

    protected void GridViewOnNeedOfDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        SetReportParameters();
    }

    private void PopulateRdgrdPatTreatmentOnDataSource(DateTime? startDate, DateTime? endDate, string surveytypeid, string facilityid, string notetype, string scoretype)
    {

        System.Data.DataTable dataTableGrid = SqlProvider.ExecuteSPDataTable(
                "RegistryConnectionString", "[TBI].[GetAllPatientOutcomeChangesReport]",
                new object[] { startDate, endDate, surveytypeid, facilityid, notetype, scoretype });

        if (dataTableGrid != null)
        {
            rdgrdPatTreatment.DataSource = dataTableGrid;
            rdgrdPatTreatment.DataBind();
        }
    }


    void Page_PreRender(object sender, EventArgs e)
    {
        EnableButtonRunReport();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        SetReportParameters();
    }

    private void SetReportPath()
    {
    }

    protected void SetReportParameters()
    {
        try
        {
            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            string _facilitylist = String.Empty;
            string _notetypelist = String.Empty;
            string _surveytypelist = String.Empty;
            string _scoretypelist = String.Empty;
            ////ReportParameter reportParam = new ReportParameter("UserId", userId);
            ////_reportParameters.Add(reportParam);

            if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null || DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
            {
                if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null)
                {
                    lblDateValidation.Visible = true;
                    DateFrom.Focus();
                }
                if (DateTo.DateValue.Length == 0 || DateTo.DateValue == null)
                {
                    lblDateValidation2.Visible = true;
                    DateTo.Focus();
                }
            }
            else
            {
                lblDateValidation.Visible = false;
                lblDateValidation2.Visible = false;
                if (DropDownListReportLevel.SelectedValue == "National")
                {
                    DateTime? startDateN = null;
                    DateTime? endDateN = null;
                    if (DateFrom.DateValue.Length > 0 && DateTo.DateValue.Length > 0)
                    {
                        if (Convert.ToDateTime(DateTo.DateValue) < Convert.ToDateTime(DateFrom.DateValue))
                        {
                            lblDateValidation3.Visible = true;
                            DateFrom.Focus();
                        }
                        else
                        {
                            lblDateValidation3.Visible = false;
                        }

                        if (DateFrom.DateValue != null)
                        {
                            startDateN = Convert.ToDateTime(DateFrom.DateValue);
                        }
                        if (DateTo.DateValue != null)
                        {
                            endDateN = Convert.ToDateTime(DateTo.DateValue);
                        }

                        foreach (ListItem item in ddlSurveyTypes.Items)
                        {
                            if (item.Selected)
                            {
                                _surveytypelist += item.Value + ", ";
                            }
                        }
                        if (_surveytypelist.Length > 0) { _surveytypelist = _surveytypelist.Substring(0, _surveytypelist.Length - 2); }

                        foreach (ListItem item in CheckBoxScoreType.Items)
                        {
                            if (item.Selected)
                            {
                                _scoretypelist += item.Value;
                            }
                        }

                        foreach (ListItem item in CheckBoxNoteStatus.Items)
                        {
                            if (item.Selected)
                            {
                                _notetypelist += item.Value + ", ";
                            }
                        }
                        if (_notetypelist.Length > 0) { _notetypelist = _notetypelist.Substring(0, _notetypelist.Length - 2); }
                        //lblReportTitle.Visible = true;
                        PopulateRdgrdPatTreatmentOnDataSource(startDateN, endDateN, _surveytypelist, null, _notetypelist, _scoretypelist);
                    }
                }
                else if (DropDownListReportLevel.SelectedValue == "VISN")
                {
                    #region Selected All FAcs by Visn

                    //if (DropDownListVisnID.SelectedIndex > 0)
                    //{
                    //    ReportParameter reportParamFromDate = new ReportParameter("NOTEDATE", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                    //    _reportParameters.Add(reportParamFromDate);
                    //    ReportParameter reportParamToDate = new ReportParameter("NOTEDATE2", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
                    //    _reportParameters.Add(reportParamToDate);

                    //    foreach (ListItem item in ddlSurveyTypes.Items)
                    //    {
                    //        if (item.Selected)
                    //        {
                    //            _surveytypelist += item.Value + "','";
                    //        }
                    //    }
                    //    if (_surveytypelist.Length > 0) { _surveytypelist = _surveytypelist.Substring(0, _surveytypelist.Length - 2); }
                    //    ReportParameter reportParamSurveyTypeString = new ReportParameter("SURVEYTYPEID", _surveytypelist);
                    //    _reportParameters.Add(reportParamSurveyTypeString);

                    //    System.Data.DataTable dataTable = SqlProvider.ExecuteSPDataTable(
                    //          "RegistryConnectionString", "TBI_GetPermittedStations",
                    //          new object[] { DropDownListVisnID, _currentUser.UserName });

                    //    if (dataTable != null)
                    //    {
                    //        for (int i = 0; i < dataTable.Rows.Count; i++)
                    //        {
                    //            if (_facilitylist.Length == 0) { _facilitylist = "'"; }
                    //            _facilitylist += dataTable.Rows[i]["institution_id"].ToString() + ", ";
                    //        }

                    //        if (_facilitylist.Length > 0) { _facilitylist = _facilitylist.Substring(0, _facilitylist.Length - 2); }
                    //    }

                    //    ReportParameter reportParamVisnId = new ReportParameter("FacilityID", (_facilitylist));
                    //    _reportParameters.Add(reportParamVisnId);
                    //    foreach (ListItem item in CheckBoxNoteStatus.Items)
                    //    {
                    //        if (item.Selected)
                    //        {
                    //            if (_notetypelist.Length == 0) { _notetypelist = "'"; }
                    //            _notetypelist += item.Value + "','";
                    //        }
                    //    }
                    //    if (_notetypelist.Length > 0) { _notetypelist = _notetypelist.Substring(0, _notetypelist.Length - 2); }
                    //    ReportParameter reportParamNoteType = new ReportParameter("NoteType", _notetypelist);
                    //    _reportParameters.Add(reportParamNoteType);

                    //    ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());
                    //}
                    #endregion
                }
                else
                {
                    DateTime? startDate = null;
                    DateTime? endDate = null;
                    if (DateFrom.DateValue.Length > 0 && DateTo.DateValue.Length > 0)
                    {
                        if (Convert.ToDateTime(DateTo.DateValue) < Convert.ToDateTime(DateFrom.DateValue))
                        {
                            lblDateValidation3.Visible = true;
                            DateFrom.Focus();
                        }
                        else
                        {
                            lblDateValidation3.Visible = false;
                        }
                        if (DropDownListFacility.SelectedIndex > 0)
                        {
                            if (DateFrom.DateValue != null)
                            {
                                startDate = Convert.ToDateTime(DateFrom.DateValue);
                            }
                            if (DateTo.DateValue != null)
                            {
                                endDate = Convert.ToDateTime(DateTo.DateValue);
                            }

                            foreach (ListItem item in ddlSurveyTypes.Items)
                            {
                                if (item.Selected)
                                {
                                    _surveytypelist += item.Value + ", ";
                                }
                            }
                            if (_surveytypelist.Length > 0) { _surveytypelist = _surveytypelist.Substring(0, _surveytypelist.Length - 2); }

                            foreach (ListItem item in CheckBoxScoreType.Items)
                            {
                                if (item.Selected)
                                {
                                    _scoretypelist += item.Value;
                                }
                            }

                            System.Data.DataSet ds = new System.Data.DataSet();
                            System.Data.DataView dv = (System.Data.DataView)this.ObjectDataSource3.Select();
                            ds.Tables.Add(dv.ToTable());

                            foreach (ListItem item in DropDownListFacility.Items)
                            {
                                if (item.Selected)
                                {
                                    for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                                    {
                                        if (item.Value == ds.Tables[0].Rows[i][2].ToString())
                                        {
                                            _facilitylist += ds.Tables[0].Rows[i][5].ToString() + ", ";
                                            break;
                                        }
                                    }
                                }
                            }
                            if (_facilitylist.Length > 0) { _facilitylist = _facilitylist.Substring(0, _facilitylist.Length - 2); }

                            foreach (ListItem item in CheckBoxNoteStatus.Items)
                            {
                                if (item.Selected)
                                {
                                    _notetypelist += item.Value + ", ";
                                }
                            }
                            if (_notetypelist.Length > 0) { _notetypelist = _notetypelist.Substring(0, _notetypelist.Length - 2); }
                            //lblReportTitle.Visible = true;
                            PopulateRdgrdPatTreatmentOnDataSource(startDate, endDate, _surveytypelist, _facilitylist, _notetypelist, _scoretypelist);
                        }
                    }
                }
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Get() ReportData");
        }
    }


    protected void DropDownListReportLevel_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            if (DropDownListReportLevel.SelectedValue == "Select One")
            {
                ButtonRunReport.Enabled = false;
                EnableDropDownListsVisnAndStation(false, false);
            }
            else if (DropDownListReportLevel.SelectedValue == "National")
            {
                ButtonRunReport.Enabled = true;
                EnableDropDownListsVisnAndStation(false, false);
                ButtonRunReport.Enabled = true;
            }
            else
            {
                EnableDropDownListsVisnAndStation(true, false);
                SetDropDownListVisnId();
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Report Level Selecting");
        }
    }

    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            if (DropDownListReportLevel.SelectedValue == "VISN")
            {
                EnableDropDownListsVisnAndStation(true, false);
               
            }
            else if (DropDownListReportLevel.SelectedValue == "Station")
            {
                SetDropDownListFacility();
                EnableDropDownListsVisnAndStation(true, true);
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Visn Selected");
        }
    }

    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Stations Selecting");
        }
    }

    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Visn Selecting");
        }
    }

    #endregion

    #region Private Methods

    private void SetDropDownListVisnId()
    {
        try
        {
            if (!_currentUser.IsInRole(16))
            {
                if (DropDownListReportLevel.SelectedValue == "VISN")
                {
                    DropDownListVisnID.DataSource = ObjectDataSourceDirectlyPermittedVISNs;
                }
                else if (DropDownListReportLevel.SelectedValue == "Station")
                {
                    DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
                }
                DropDownListVisnID.DataBind();
                DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
            }
            DropDownListVisnID.SelectedIndex = 0;
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "SetDropDownListVisnId()");
        }
    }

    private void SetDropDownListFacility()
    {
        try
        {
            if (DropDownListVisnID.SelectedIndex != 0)
            {
                if (_currentUser.IsInRole(16))
                {
                    DropDownListFacility.DataSource = ObjectDataSource3;
                }
                else
                {
                    DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
                }
                DropDownListFacility.DataBind();
                DropDownListFacility.Items.Insert(0, new ListItem("Select Facilities", "000"));
                DropDownListFacility.SelectedIndex = 0;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "SetDropDownListFacility()");
        }
    }

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        string myrolename = _currentUser.RoleName.ToString();
        if (myrolename.IndexOf("TBI Rehabilitation and Polytrauma Clinicians") > -1)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    private void SetDropDownListLevel()
    {
        try
        {
            _currentUser = (UserAccountManager)HttpContext.Current.User;
            AddListItem("Select One");
            //TODO ROLE
            if (_currentUser.IsInRole(16))
            {
                AddListItem("National");
                //AddListItem("VISN");
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }

            if (_currentUser.IsInRole(17))
            {
                //AddListItem("VISN");
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }

            if (_currentUser.IsInRole(18))
            {
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Fucntion SetDropDownListLevel()");
        }
    }

    private void AddListItem(string itemValue)
    {
        try
        {
            var listItem = new ListItem(itemValue);
            if (!DropDownListReportLevel.Items.Contains(listItem))
            {
                DropDownListReportLevel.Items.Add(listItem);
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Function AddListItem()");
        }
    }

    private void EnableDropDownListsVisnAndStation(bool dropDownListVisnIdIsVisible, bool dropDownListFacilityIsVisible)
    {
        DropDownListVisnID.Visible = dropDownListVisnIdIsVisible;
        //DivVISN.Visible = dropDownListVisnIdIsVisible;
        DropDownListFacility.Visible = dropDownListFacilityIsVisible;
        // DivStation.Visible = dropDownListFacilityIsVisible;
    }

    private void EnableButtonRunReport()
    {
        try
        {//DropDownListReportLevel.SelectedValue == "VISN" && 
            if (DropDownListReportLevel.SelectedValue == "Select One" ||
                    (DropDownListReportLevel.SelectedValue == "VISN" && DropDownListVisnID.SelectedIndex < 1) ||
                    (DropDownListReportLevel.SelectedValue == "Station" &&
                     (DropDownListVisnID.SelectedIndex < 1
                      || DropDownListFacility.SelectedIndex < 1))
                   )
            {
                ButtonRunReport.Enabled = false;
            }
            else
            {
                ButtonRunReport.Enabled = true;
                //mngBtnWordExcel.Enabled = true;
                //mngBtnExportPDF.Enabled = true;
                //mngBtnExportWord.Enabled = true;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Fucntion EnableButtonRunReport()");
        }
    }

    private void DisableReportViewer()
    {
        ReportViewerNational.Visible = false;
        ReportViewerVisn.Visible = false;
        ReportViewerStation.Visible = false;
    }

    #endregion


    protected void rdgrdPatTreatment_ItemDataBound(object sender, GridItemEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }

    protected void rdgrdPatTreatment_PageIndexChanged(object sender, GridPageChangedEventArgs e)
    {
        RadAjaxLoadingPanel1.EnableAjaxSkinRendering = true;
    }
}
